---
title: Supported cipher suites · Cloudflare SSL/TLS docs
description: Cloudflare supports the following cipher suites by default. If
  needed, you can restrict your website or application to only use specific
  cipher suites.
lastUpdated: 2024-11-29T14:44:43.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/edge-certificates/additional-options/cipher-suites/supported-cipher-suites/
  md: https://developers.cloudflare.com/ssl/edge-certificates/additional-options/cipher-suites/supported-cipher-suites/index.md
---

Cloudflare supports the following cipher suites by default. If needed, you can [restrict your website or application](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/cipher-suites/customize-cipher-suites/) to only use specific cipher suites.

| Cipher name | Minimum protocol | [Security recommendation](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/cipher-suites/recommendations/) | Cipher suite | IANA name |
| - | - | - | - | - |
| ECDHE-ECDSA-AES128-GCM-SHA256 | TLS 1.2 | Modern | \[0xc02b] | TLS\_ECDHE\_ECDSA\_WITH\_AES\_128\_GCM\_SHA256 |
| ECDHE-ECDSA-CHACHA20-POLY1305 | TLS 1.2 | Modern | \[0xcca9] | TLS\_ECDHE\_ECDSA\_WITH\_CHACHA20\_POLY1305\_SHA256 |
| ECDHE-RSA-AES128-GCM-SHA256 | TLS 1.2 | Modern | \[0xc02f] | TLS\_ECDHE\_RSA\_WITH\_AES\_128\_GCM\_SHA256 |
| ECDHE-RSA-CHACHA20-POLY1305 | TLS 1.2 | Modern | \[0xcca8] | TLS\_ECDHE\_RSA\_WITH\_CHACHA20\_POLY1305\_SHA256 |
| ECDHE-ECDSA-AES128-SHA256 | TLS 1.2 | Compatible | \[0xc023] | TLS\_ECDHE\_ECDSA\_WITH\_AES\_128\_CBC\_SHA256 |
| ECDHE-ECDSA-AES128-SHA | TLS 1.0 | Legacy | \[0xc009] | TLS\_ECDHE\_ECDSA\_WITH\_AES\_128\_CBC\_SHA |
| ECDHE-RSA-AES128-SHA256 | TLS 1.2 | Compatible | \[0xc027] | TLS\_ECDHE\_RSA\_WITH\_AES\_128\_CBC\_SHA256 |
| ECDHE-RSA-AES128-SHA | TLS 1.0 | Legacy | \[0xc013] | TLS\_ECDHE\_RSA\_WITH\_AES\_128\_CBC\_SHA |
| AES128-GCM-SHA256 | TLS 1.2 | Legacy | \[0x9c] | TLS\_RSA\_WITH\_AES\_128\_GCM\_SHA256 |
| AES128-SHA256 | TLS 1.2 | Legacy | \[0x3c] | TLS\_RSA\_WITH\_AES\_128\_CBC\_SHA256 |
| AES128-SHA | TLS 1.0 | Legacy | \[0x2f] | TLS\_RSA\_WITH\_AES\_128\_CBC\_SHA |
| ECDHE-ECDSA-AES256-GCM-SHA384 | TLS 1.2 | Modern | \[0xc02c] | TLS\_ECDHE\_ECDSA\_WITH\_AES\_256\_GCM\_SHA384 |
| ECDHE-ECDSA-AES256-SHA384 | TLS 1.2 | Compatible | \[0xc024] | TLS\_ECDHE\_ECDSA\_WITH\_AES\_256\_CBC\_SHA384 |
| ECDHE-RSA-AES256-GCM-SHA384 | TLS 1.2 | Modern | \[0xc030] | TLS\_ECDHE\_RSA\_WITH\_AES\_256\_GCM\_SHA384 |
| ECDHE-RSA-AES256-SHA384 | TLS 1.2 | Compatible | \[0xc028] | TLS\_ECDHE\_RSA\_WITH\_AES\_256\_CBC\_SHA384 |
| ECDHE-RSA-AES256-SHA | TLS 1.0 | Legacy | \[0xc014] | TLS\_ECDHE\_RSA\_WITH\_AES\_256\_CBC\_SHA |
| AES256-GCM-SHA384 | TLS 1.2 | Legacy | \[0x9d] | TLS\_RSA\_WITH\_AES\_256\_GCM\_SHA384 |
| AES256-SHA256 | TLS 1.2 | Legacy | \[0x3d] | TLS\_RSA\_WITH\_AES\_256\_CBC\_SHA256 |
| AES256-SHA | TLS 1.0 | Legacy | \[0x35] | TLS\_RSA\_WITH\_AES\_256\_CBC\_SHA |
| DES-CBC3-SHA | TLS 1.0 | Legacy | \[0x0a] | TLS\_RSA\_WITH\_3DES\_EDE\_CBC\_SHA |
| AEAD-AES128-GCM-SHA256 \* | TLS 1.3 | Modern | {0x13,0x01} | TLS\_AES\_128\_GCM\_SHA256 |
| AEAD-AES256-GCM-SHA384 \* | TLS 1.3 | Modern | {0x13,0x02} | TLS\_AES\_256\_GCM\_SHA384 |
| AEAD-CHACHA20-POLY1305-SHA256 \* | TLS 1.3 | Modern | {0x13,0x03} | TLS\_CHACHA20\_POLY1305\_SHA256 |

\* TLS 1.3 minimum protocol

Ciphers `AEAD-AES128-GCM-SHA256`, `AEAD-AES256-GCM-SHA384`, and `AEAD-CHACHA20-POLY1305-SHA256` are automatically supported by your zone if you [enable TLS 1.3](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/tls-13/#enable-tls-13).

TLS 1.3 uses the same cipher suite space as previous versions of TLS, but defines these cipher suites differently. TLS 1.3 only specifies the symmetric ciphers and cannot be used for TLS 1.2. Similarly, TLS 1.2 and lower cipher suites cannot be used with TLS 1.3 ([RFC 8446](https://www.rfc-editor.org/rfc/rfc8446.html)). BoringSSL also hard-codes cipher preferences in this order for TLS 1.3.
