---
title: Redirect requests for a domain to a new domain · Cloudflare Rules docs
description: Create a redirect rule to redirect all URLs for a domain to point
  to the root of a new domain, including any subdomains of the old domain.
lastUpdated: 2025-11-07T12:38:03.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-all-different-domain-root/
  md: https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-all-different-domain-root/index.md
---

In this example, an old website was discontinued and replaced by a new one in a different domain. The functionality is different, and all URLs should now point to the root of the new domain. The same applies to any subdomains of the old domain.

[Create a redirect rule](https://developers.cloudflare.com/rules/url-forwarding/single-redirects/create-dashboard/) with the following configuration:

**When incoming requests match**

* **Wildcard pattern**
  * **Request URL**: `http*://*example.com/*`

**Then**

* **Target URL**: `https://example.net/`
* **Status code:** *301*

For example, the redirect rule would perform the following redirects:

| Request URL | Target URL | Status code |
| - | - | - |
| `http://example.com/` | `https://example.net/` | `301` |
| `https://example.com/` | `https://example.net/` | `301` |
| `https://subdomain.example.com/` | `https://example.net/` | `301` |
| `https://example.com/my/path/to/page.htm` | `https://example.net/` | `301` |
| `https://example.com/search?q=term` | `https://example.net/` | `301` |
