---
title: Logpush datasets · Cloudflare Data Localization Suite docs
description: The table below lists the Logpush datasets that support zones or
  accounts with Customer Metadata Boundary (CMB) enabled. The column Respects
  CMB indicates whether enabling CMB impacts the dataset (yes/no). The last two
  columns inform you if CMB is available with US and EU.
lastUpdated: 2025-10-27T15:00:52.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/data-localization/metadata-boundary/logpush-datasets/
  md: https://developers.cloudflare.com/data-localization/metadata-boundary/logpush-datasets/index.md
---

The table below lists the [Logpush datasets](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/) that support zones or accounts with Customer Metadata Boundary (CMB) enabled. The column **Respects CMB** indicates whether enabling CMB impacts the dataset (yes/no). The last two columns inform you if CMB is available with US and EU.

Be aware that if you enable CMB for a dataset that does not support your region, no data will be pushed to your destination.

| Dataset name | Level | Respects CMB | Available with US CMB region | Available with EU CMB region |
| - | - | - | - | - |
| HTTP requests | Zone | ✅ | ✅ | ✅ |
| Firewall events | Zone | ✅ | ✅ | ✅ |
| DNS logs | Zone | ✅ | ✅ | ✅ |
| DNS Firewall logs | Account | ✅ | ✅ | ✅ |
| Spectrum events | Zone | ✅ | ✅ | ✅ |
| Magic IDS Detections | Account | ✅ | ✅ | ✅ |
| Workers Trace Events | Account | ✅ | ✅ | ✅ |
| Zero Trust Sessions | Account | ✅ | ✅ | ✅ |
| Gateway DNS | Account | ✅ | ✅ | ✅ |
| Gateway Network | Account | ✅ | ✅ | ✅ |
| Gateway HTTP | Account | ✅ | ✅ | ✅ |
| Page Shield | Zone | ✅ | ✅ | ✅ |
| Sinkhole Events | Account | ✅ | ✅ | ✅ |
| AI Gateway Events | Account | ✅ | ✅ | ✅ |
| DLP Forensic Copies | Account | N/A[1](#user-content-fn-1) | ✘ | ✘ |
| Email security Alerts | Account | ✅ | ✅ | ✅ |
| Zaraz Events | Zone | ✅ | ✅ | ✅ |
| Browser Isolation User Actions | Account | ✅ | ✅ | ✅ |
| NEL reports | Zone | ✘ | ✅ | ✘ |
| CASB Findings | Account | ✘ | ✅ | ✘ |
| Network Analytics Logs | Account | ✅ | ✅ | ✅ |
| Device Posture Results | Account | ✘ | ✅ | ✘ |
| Audit Logs | Account | ✘ | ✅ | ✘ |
| Access Requests | Account | ✅ | ✅ | ✅ |
| IPSec Logs | Account | ✅ | ✅ | ✅ |

## Footnotes

1. Customer Metadata Boundary does not apply in this case, as these logs are sent directly from the processing location to your configured destination. [↩](#user-content-fnref-1)
