---
title: D1 can restrict data localization with jurisdictions · Changelog
description: A D1 database can set a jurisdiction at creation, which limits the
  location to run and store the database.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-11-05-d1-jurisdiction/
  md: https://developers.cloudflare.com/changelog/2025-11-05-d1-jurisdiction/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## D1 can restrict data localization with jurisdictions

Nov 05, 2025

[D1 ](https://developers.cloudflare.com/d1/)[Workers](https://developers.cloudflare.com/workers/)

You can now set a [jurisdiction](https://developers.cloudflare.com/d1/configuration/data-location/) when creating a D1 database to guarantee where your database runs and stores data. Jurisdictions can help you comply with data localization regulations such as GDPR. Supported jurisdictions include `eu` and `fedramp`.

A jurisdiction can only be set at database creation time via wrangler, REST API or the UI and cannot be added/updated after the database already exists.

```sh
npx wrangler@latest d1 create db-with-jurisdiction --jurisdiction eu
```

```plaintext
curl -X POST "https://api.cloudflare.com/client/v4/accounts/<account_id>/d1/database" \
     -H "Authorization: Bearer $TOKEN" \
     -H "Content-Type: application/json" \
     --data '{"name": "db-wth-jurisdiction", "jurisdiction": "eu" }'
```

To learn more, visit D1's data location [documentation](https://developers.cloudflare.com/d1/configuration/data-location/).
